# Luciphor #

Luc_PXD000923_05FDR <- read.csv('D:/LuciphorData/PXD000923/Luc_PXD000923_05FDR.csv')
Luc_PXD002222_05FDR <- read.csv('D:/LuciphorData/PXD002222/Luc_PXD002222_05FDR.csv')
Luc_PXD002756_05FDR <- read.csv('D:/LuciphorData/PXD002756/Luc_PXD002756_05FDR.csv')
Luc_PXD004705_05FDR <- read.csv('D:/LuciphorData/PXD004705/Luc_PXD004705_05FDR.csv')
Luc_PXD004939_05FDR <- read.csv('D:/LuciphorData/PXD004939/Luc_PXD004939_05FDR.csv')
Luc_PXD005241_05FDR <- read.csv('D:/LuciphorData/PXD005241/Luc_PXD005241_05FDR.csv')
#Luc_PXD012764_05FDR <- read.csv('D:/LuciphorData/PXD012764/Luc_PXD012764_05FDR.csv')
Luc_PXD019291_05FDR <- read.csv('D:/LuciphorData/PXD019291/Luc_PXD019291_05FDR.csv')

All_Luciphor_05FDR <- rbind.data.frame(Luc_PXD000923_05FDR,Luc_PXD002222_05FDR,Luc_PXD002756_05FDR,Luc_PXD004705_05FDR,Luc_PXD004939_05FDR,
                                       Luc_PXD005241_05FDR,Luc_PXD019291_05FDR)

All_Luciphor_05FDR$PROTEIN_LOC <- paste0(All_Luciphor_05FDR$Protein,"_",All_Luciphor_05FDR$Protein.position)
All_Luciphor_05FDR_Uniq <- distinct(All_Luciphor_05FDR,PROTEIN_LOC, .keep_all = TRUE)

Musite_Luciphor <- merge(All_Luciphor_05FDR_Uniq,AllRice_Musite,by="PROTEIN_LOC",all.x = TRUE)

Musite_Luciphor$Pipeline <- "Luciphor"
Musite_Luciphor$cat <- "None"
Musite_Luciphor$Amino <- str_sub(substr(Musite_Luciphor$peptide,1,Musite_Luciphor$PTM.positions),-1)

R_Musite_Luciphor <- dplyr::select(Musite_Luciphor,c("PROTEIN_LOC","globalFLR", "Pipeline", "Scores","cat", "Amino"))

names(R_Musite_Luciphor)[names(R_Musite_Luciphor) == "globalFLR"] <- "FLR_Adj_Score"

Musite_Luci_TPP <- rbind.data.frame(R_Musite_Luciphor,All_Results_Musite_NA)

Musite_Luci_TPP <- Musite_Luci_TPP[(Musite_Luci_TPP$Pipeline!="PD")&(Musite_Luci_TPP$Pipeline!="MQ"),]

boxplot(Scores~cat,data=Musite_Luci_TPP)

pairwise.wilcox.test(Musite_Luci_TPP$Scores, Musite_Luci_TPP$cat, p.adjust.method = "BH",
                     paired = FALSE)

tapply(Musite_Luci_TPP$Scores, Musite_Luci_TPP$cat,
       function(x) format(summary(x), scientific = TRUE))